import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import '../theme/color_palette.dart';

void setStatusBar({bool isHome = false, required bool isDark }) {

  // final bool isIos = Platform.isIOS;
  WidgetsBinding.instance.addPostFrameCallback((_) {
    try {
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual, overlays: SystemUiOverlay.values);
      if(isHome){
        SystemChrome.setSystemUIOverlayStyle(SystemUiOverlayStyle(
          statusBarColor: isDark ? ColorPalette.primary20 : ColorPalette.primary50,
          statusBarIconBrightness: Brightness.light,
          statusBarBrightness: Brightness.dark,
        ));
      }else{
        isDark ? setDarkStatusBar() : setLightStatusBar();
        // if(isIos){
        //   isDark ? setDarkStatusBar() : setLightStatusBar();
        // }else{
        //   isDark ? setDarkStatusBar() : setLightStatusBar();
        // }

      }

      // SystemChrome.setSystemUIOverlayStyle(
      //   isHome
      //       ?  SystemUiOverlayStyle(
      //     statusBarColor: isDark ? ColorPalette.primary20 : ColorPalette.primary50,
      //     statusBarIconBrightness: Brightness.light,
      //     statusBarBrightness: Brightness.dark,
      //   )
      //       :
      //   SystemUiOverlayStyle(
      //     statusBarColor: isDark ? Colors.black : Colors.white,
      //     statusBarIconBrightness: isDark ? Brightness.light : Brightness.dark,
      //     statusBarBrightness: Brightness.light, //isDark ? Brightness.dark :
      //   ),
      // );
    } catch (e) {
      if(true){}
    }
  });
}

void setDarkStatusBar({Color? color}) {
  SystemChrome.setEnabledSystemUIMode(
    SystemUiMode.manual,
    overlays: SystemUiOverlay.values,
  );
  SystemChrome.setSystemUIOverlayStyle(
    SystemUiOverlayStyle(
      statusBarColor: color ?? Colors.black,
      statusBarIconBrightness: Brightness.light,
      statusBarBrightness: Brightness.dark,
    ),
  );
}

/// Apply light mode status bar (white background + dark icons)
void setLightStatusBar() {
  SystemChrome.setEnabledSystemUIMode(
    SystemUiMode.manual,
    overlays: SystemUiOverlay.values,
  );
  SystemChrome.setSystemUIOverlayStyle(
    const SystemUiOverlayStyle(
      statusBarColor: Colors.white,
      statusBarIconBrightness: Brightness.dark,
      statusBarBrightness: Brightness.light,
    ),
  );
}